/*
 * MovementInfoCollection.h
 *
 * Created 8/23/2009 By Johnny Huynh
 *
 * Version 00.00.01 8/23/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef MOVEMENT_INFO_COLLECTION_H
 #define MOVEMENT_INFO_COLLECTION_H
 
 template <typename T> class MovementInfoCollection;
 
 #include "global.h"
 
 #include "pointerTo.h"
 #include "MovementInfo.h"
 #include <list>
 
 /**
  * Class specification for MovementInfoCollection
  * The order the MovementInfos are added to this collection determines
  * the order the movements are processed; treat this collection like
  * a queue.
  */
 template <typename T>
 class MovementInfoCollection : private std::list<PT(MovementInfo<T>)>
 {
 // Data Members
 protected:
 typedef std::list<PT(MovementInfo<T>)> std_list;
    
 // Local Functions
 public:
    MovementInfoCollection();
    MovementInfoCollection( const MovementInfoCollection<T>& movement_info_collection );
    virtual ~MovementInfoCollection();
    inline MovementInfoCollection<T>& operator=( const MovementInfoCollection<T>& movement_info_collection );
    inline void add( MovementInfo<T>* movement_info_Ptr );
    inline void clear();
    inline MovementInfo<T>* get_front();
    inline void remove_front();
    inline size_t size() const;
 
 // Private Functions
 private:
    
 // Friend Functions
 public:
    
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 MovementInfoCollection<T>::MovementInfoCollection()
                           : std_list()
 {
    
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 MovementInfoCollection<T>::MovementInfoCollection( const MovementInfoCollection<T>& movement_info_collection )
                           : std_list( movement_info_collection )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 MovementInfoCollection<T>::~MovementInfoCollection()
 {
    
 }
 
 /**
  * operator=() copies the content of the specified MovementInfoCollection to this MovementInfoCollection.
  *
  * @param (const MovementInfoCollection<T>&) movement_info_collection
  * @return MovementInfoCollection<T>&
  */
 template <typename T>
 inline MovementInfoCollection<T>& MovementInfoCollection<T>::operator=( const MovementInfoCollection<T>& movement_info_collection )
 {
    std_list::operator=( movement_info_collection );
    
    return *this;
 }
 
 /**
  * add() adds the specified MovementInfo pointed to to this collection.
  *
  * @param (MovementInfo<T>*) movement_info_Ptr
  */
 template <typename T>
 inline void MovementInfoCollection<T>::add( MovementInfo<T>* movement_info_Ptr )
 {
    std_list::push_back( movement_info_Ptr );
 }
 
 /**
  * clear() removes all MovementInfos from this collection.
  */
 template <typename T>
 inline void MovementInfoCollection<T>::clear()
 {
    std_list::clear();
 }
 
 /**
  * get_front() returns the first MovementInfo pointer in this collection.
  *
  * @param (size_t) i
  * @return MovementInfo<T>*
  */
 template <typename T>
 inline MovementInfo<T>* MovementInfoCollection<T>::get_front()
 {
    return std_list::front();
 }
 
 /**
  * remove_front() removes the first MovementInfo from this collection.
  */
 template <typename T>
 inline void MovementInfoCollection<T>::remove_front()
 {
    std_list::pop_front();
 }
 
 /**
  * size() returns the number of MovementInfos in this collection.
  *
  * @return size_t
  */
 template <typename T>
 inline size_t MovementInfoCollection<T>::size() const
 {
    return std_list::size();
 }
 
 /** FRIEND FUNCTIONS **/
 
 #endif // MOVEMENT_INFO_COLLECTION_H